import math
import random

import alg
import numpy as np

for K in [600]:

    T = 1000
    L = 2
    minV = np.array([0,20])
    maxV = np.array([50,70])
    granularity = 0.1
    demandFactor = 1


    Traces = 5
    Rounds = 15
    praticalCRs = []
    for j in range(Rounds):
        KList = np.array([1100,1100])
        checkKl = [((KList[i]/T >= 1) or (KList[i]/T == 0)) for i in range(L)]
        checkTotal = checkKl[0]
        for i in range(L):
            checkTotal = checkTotal or checkKl[i]
        while(checkTotal):
            factorl = []
            for i in range(L):
                factorl.append(random.uniform(0,1))
            for i in range(L):
                KList[i]=(factorl[i]/sum(factorl))*K*L*demandFactor
            checkKl = [((KList[i] / T >= 1) or (KList[i] / T == 0)) for i in range(L)]
            checkTotal = checkKl[0]
            for i in range(L):
                checkTotal = checkTotal or checkKl[i]
        consumptionArray = alg.generateConsumptionArrayBeta(
            T=T,
            L=L,
            KList=KList,
            granularity=granularity
        )
        valueArray = alg.generateValueArray(
            T=T,
            L=L,
            maxVList=maxV,
            minVList=minV,
            granularity=granularity
        )

        gamma = (1-math.pow(K,-0.5))/L
        print("T: ", T, "; L: ",L)
        for l in range(L):
            print("Level" , l+1, " value range:[", minV[l], ",", maxV[l], "]")
        print("KList: ", KList)

        accumulatedReward = 0
        averageRunTime = 0
        for i in range(Traces):
            thisAccumulatedReward, thisAverageRunTime = alg.OLSFake(
                T=T,
                L=L,
                K=K,
                gamma=gamma,
                consumptionArray=consumptionArray,
                valueArray=valueArray,
                granularity=granularity
            )
            accumulatedReward+=thisAccumulatedReward
            averageRunTime += thisAverageRunTime
        expectedReward = accumulatedReward/Traces
        averageRunTime = averageRunTime/Traces
        print("averageRunTime(per task)(ms): ", averageRunTime*1000)
        print("practical CR: ", expectedReward/np.sum(valueArray))
        praticalCRs.append(expectedReward/np.sum(valueArray))
    theoreticalCR = gamma
    print("theoretical CR: ", theoreticalCR)
    print("theoretical accumulated reward lowerbound: ", np.sum(valueArray)*theoreticalCR)
    print("practical CR: ", praticalCRs)